<?php

namespace App\Services;

use Illuminate\Support\Facades\Storage;

class AiSchemaService
{
    public function getSchemaSummary(int $maxTables = 50, int $maxColsPerTable = 12): string
    {
        $path = 'ai/schema.json';
        if (!Storage::disk('local')->exists($path)) {
            return '';
        }
        $raw = Storage::disk('local')->get($path);
        $data = json_decode((string)$raw, true);
        if (!is_array($data) || empty($data['tables'])) {
            return '';
        }

        $lines = [];
        $tables = array_slice($data['tables'], 0, $maxTables, true);
        foreach ($tables as $table => $info) {
            $cols = array_slice((array)($info['columns'] ?? []), 0, $maxColsPerTable);
            $cNames = array_map(function ($c) { return $c['name'] . ':' . $c['type']; }, $cols);
            $suffix = isset($info['count']) && $info['count'] !== null ? (' rows=' . (int)$info['count']) : '';
            $lines[] = $table . ' (' . implode(',', $cNames) . ')' . $suffix;
        }

        return "DB Schema (subset):\n" . implode("\n", $lines);
    }
}

